<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (!isset($_GET['id'])) {
    header('Location: professeurs.php');
}

$id = $_GET['id'];

if (isset($_GET['supprimer'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare("DELETE FROM professeur WHERE id_professeur=:id");
        $requete->bindParam(':id', $id);
        $requete->execute();
        $bdd->commit();

        header('Location: professeurs.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();

        $requete = $bdd->prepare('UPDATE professeur SET nom_professeur=:nom, prenom_professeur=:prenom WHERE id_professeur=:id');
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':prenom', $_POST['prenom']);
        $requete->bindParam(':id', $id);
        $requete->execute();

        $bdd->commit();

        header('Location: professeurs.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }

}

$requete = $bdd->prepare("SELECT * FROM professeur WHERE id_professeur=:id");
$requete->bindParam(':id', $id);
$requete->execute();
$professeur = $requete->fetch();

include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Modification d'un professeur - <a href="edition-professeur.php?id=<?php echo htmlspecialchars($id) ?>&supprimer">Supprimer ce professeur</a> </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom" value="<?php echo htmlspecialchars($professeur['nom_professeur']) ?>">
                                    <label>Prénom</label>
                                    <input class="form-control" name="prenom" value="<?php echo htmlspecialchars($professeur['prenom_professeur']) ?>">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
